/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.statExamples;

import gis.sessExamples.*;
import gis.services.statistic.StatService;
import gis.services.statistic.StatServiceServiceLocator;
import gis.services.statistic.StatServiceSoapBindingStub;
import gis.services.statistic.*;

/**
 * This examples demonstrates how to make a unsolicitedNotification request.
 * To use this notification mode, client side must have a web server that
 * implements the notification.wsdl. See the example NotifyService.java.
 *
 * Date: March 25, 2003
 *
 */

public class UnsolicitedNotificationExample {

    StatService statPort;
    ConnectToServiceExample cs;

    public UnsolicitedNotificationExample() {}

    /*
     * This method is almost identical to SubscribeToStatistic.java
     * The exception is that in SubscribeToStatistic.java,
     * the UnsolicitedNotification object is not populated.
     * In this example, a client web server's host and port information
     * is set in the UnsolicitedNotification object and passed along
     * with a statistic subscription request.
     *
     * @param gisServer <gis_host>:<gis_port>
     */

    public void execute(String gisServer) throws Exception {

        String[] services = {"GIS_STATSERVICE"};

    //----------------------------------------------------------------------------//
    //This section is similar to the execute() method in SubscribeToStatistic.java
    //----------------------------------------------------------------------------//

        //first step is to connect to a service. See ConnectToServiceExample.java.
	cs = new ConnectToServiceExample(services);
        cs.execute(gisServer);

        // Make a service
        StatServiceServiceLocator statService = new gis.services.statistic.StatServiceServiceLocator();

        // Now use the service to get a stub which implements the SDI.
        statPort = statService.getStatService(new java.net.URL("http://" + gisServer + "/gis/services/StatService?GISsessionId="+ cs.sid));

        //build a statistic object
        gis.services.statistic.Statistic statistic = new gis.services.statistic.Statistic();
        statistic.setStatisticId("statref1");

        //build an ObjectIdType object
        gis.services.statistic.ObjectIdType objectId = new gis.services.statistic.ObjectIdType();
        System.out.println("Statistic needed for Agent1601");
	//enter the employee id for this method
        objectId.setId("Agent1601");
        //The agent object is under the Tenant "Resources"
        objectId.setTenantName("Resources");

        //adding object id data to statistic
        statistic.setObjectId(objectId);

        //building metric data
        gis.services.statistic.Metric metric = new gis.services.statistic.Metric();
        gis.services.statistic.StatisticType statisticType = new gis.services.statistic.StatisticType();
        gis.services.statistic.ObjectType[] objectType = new gis.services.statistic.ObjectType[]{gis.services.statistic.ObjectType.Agent};
        statisticType.setObjectType(objectType);
        metric.setStatisticType(statisticType);
        System.out.println("Statistic of interest is the agent's total login time");
        metric.setTypeName("Total_Login_Time");
        gis.services.statistic.TimeInterval timeInterval = new gis.services.statistic.TimeInterval();
        timeInterval.setIntervalType(gis.services.statistic.TimeIntervalType.GrowingWindow);
        metric.setInterval(timeInterval);

        //adding metric data to statistic
        statistic.setMetric(metric);

        //specify statistic schedule
        gis.services.statistic.Schedule schedule = new gis.services.statistic.Schedule();
        schedule.setNotificationMode(gis.services.statistic.ScheduleMode.ChangesBased);
        statistic.setSchedule(schedule);

        //-------------------------------------------------------------------------------//

        //
        // create an unsolicitedNotification object and pass in the listening
        // client server's notification service url. The client server must
        // implement the service according to GIS's notification.wsdl specification.
        //
        UnsolicitedNotification un = new UnsolicitedNotification();
        un.setUrl("http://localhost:8080/axis/services/notification");  //this url points to your client http server's notification service


        //subscribe request using the UnsolicitedNotification mode
        statPort.subscribeStatistic(statistic, "StatServer65", un);  //after this request, the client app waits for updates
        System.out.println("Waiting for statistic from GIS server...\n");

    }


    //Standalone option to test run this example. Creates a new instance
    //of this object and starts the process.
    public static void main(String[] args){

        try {
            UnsolicitedNotificationExample example = new UnsolicitedNotificationExample();
            example.execute("localhost:9090");

        } catch (Exception serviceException) {
            System.out.println(serviceException.getMessage());
        }
    }
}