/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.statExamples;

import gis.sessExamples.*;
import gis.services.statistic.StatService;
import gis.services.statistic.StatServiceServiceLocator;
import gis.services.statistic.StatServiceSoapBindingStub;
import gis.services.statistic.*;

import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.utils.Options;

import javax.xml.rpc.ParameterMode;
import javax.xml.namespace.QName;

import java.net.URL;

/**
 * This example uses the UnsolictedNotification example to make
 * an unsolicited notification request and demonstrates one implementation
 * to receive messages from a client side notification service.
 *
 * To run this example, you must implement the notification service example.
 * Deploy the NotifyService.java example. It includes a simple client message retrieval service.
 * This class calls the client service and retrieves the messages.
 *
 * Date: April 24, 2003
 *
 */

public class UnsolicitedNotificationClientExample {

   public UnsolicitedNotificationClientExample() {}

   /*
    * This method calls the client web server and request for the notification service.
    * retrieveMessage() method in NotifyService.java is an exposed method through
    * the notification service. It returns the statistic data retrieved by the notify() method.
    *
    * The variable args must contain the url to a client http server implementing
    * the notification service.
    */
   public void getMessage(String[] args) throws Exception {

      //request a unsolicited notification from GIS. See the UnsolicitedNotificationExample.java for details on this class
      UnsolicitedNotificationExample example = new UnsolicitedNotificationExample();
      example.execute("localhost:9090");      //this is your GIS server host and port

      Thread.sleep(30000); //wait 30 seconds for the statistic to come in.
      Options opts = new Options( args );
      args = opts.getRemainingArgs();
      Service  service = new Service();
      Call call = (Call) service.createCall();
      call.setTargetEndpointAddress( new java.net.URL(opts.getURL()) );
      call.setOperationName( new QName("notification", "retrieveMessage") );
      call.setReturnType( XMLType.XSD_STRING ); //this line is not always necessary

      //the server side code needs the session id to know which message to retrieve
      String res = (String) call.invoke( new Object[]{example.cs.sid});

      System.out.println("GIS request received from client http server:");
      System.out.println(res);    //display the information requested for this session client
    }


    /*
     * Standalone option to test run this example. Creates a new instance of
     * this object and starts the process.
     *
     * This class needs an input argument. Variable args0 must be
     * the url to the client http notification service.
     *
     * e.g. java gis.statExamples.UnsolicitedNotificationClientExample
     * -lhttp://localhost:8080/gisClient/myNotificationService
     */
    public static void main(String[] args){

        try {
            UnsolicitedNotificationClientExample receiveMsg = new UnsolicitedNotificationClientExample();
            receiveMsg.getMessage(args);

        } catch (Exception serviceException) {
            System.out.println(serviceException.getMessage());
        }
    }
}