/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.statExamples;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

import javax.xml.namespace.QName;

import gis.sessExamples.*;
import gis.services.statistic.StatisticValue;
import gis.services.statistic.EventValue;

/*
 * This example demonstrates how to subscribe for a statistic.
 * The code also shows how to unsubscribe from the statistic.
 *
 * @Date March 25, 2003
 */

public class SubscribeToStatisticExample{

    public gis.services.statistic.StatServiceService statService;
    public gis.services.statistic.StatService statPort;

    public SubscribeToStatisticExample(){}

    /*
     * This method uses the ConnectToServiceExample to login and retrieve the session id.
     * Then it subscribes, that is request for license, to a statistic.
     * The statistic subscribed is for an agent's total login time.
     *
     * @param gisServer String value in format of <gisHost>:<gisPort>
     */
     public void subscribe(String gisServer) throws Exception {

        String[] services = {"GIS_STATSERVICE"};

        //first step is to connect to a service. See ConnectToServiceExample.java in current folder.
	ConnectToServiceExample cs = new ConnectToServiceExample(services);
        cs.execute(gisServer);

        // Make a service
        statService = new gis.services.statistic.StatServiceServiceLocator();

        // Now use the service to get a stub which implements the SDI.
        statPort = statService.getStatService(new java.net.URL("http://" + gisServer + "/gis/services/StatService?GISsessionId="+ cs.sid));

        //build a statistic object
        gis.services.statistic.Statistic statistic = new gis.services.statistic.Statistic();
        statistic.setStatisticId("statref1");

        //building object id
        gis.services.statistic.ObjectIdType objectId = new gis.services.statistic.ObjectIdType();
        System.out.println("Statistic needed for Agent1601");
	//enter the employee id for this method
        objectId.setId("Agent1601");
        //The agent object is under the Tenant "Resources"
        objectId.setTenantName("Resources");

        //adding object id data to statistic
        statistic.setObjectId(objectId);

        //building metric data
        gis.services.statistic.Metric metric = new gis.services.statistic.Metric();
        gis.services.statistic.StatisticType statisticType = new gis.services.statistic.StatisticType();
        gis.services.statistic.ObjectType[] objectType = new gis.services.statistic.ObjectType[]{gis.services.statistic.ObjectType.Agent};
        statisticType.setObjectType(objectType);
        metric.setStatisticType(statisticType);
        System.out.println("Statistic interested is agent's total login time");
        metric.setTypeName("Total_Login_Time");
        gis.services.statistic.TimeInterval timeInterval = new gis.services.statistic.TimeInterval();
        timeInterval.setIntervalType(gis.services.statistic.TimeIntervalType.GrowingWindow);
        metric.setInterval(timeInterval);

        //adding metric data to statistic
        statistic.setMetric(metric);

        //specify statistic schedule
        gis.services.statistic.Schedule schedule = new gis.services.statistic.Schedule();
        schedule.setNotificationMode(gis.services.statistic.ScheduleMode.ChangesBased);

        //adding schedule data to statistic
        statistic.setSchedule(schedule);

        //Subscribe to the statistic. Note StatServer70 is the application name of a particular stat server
        statPort.subscribeStatistic(statistic,"StatServer70",new gis.services.statistic.UnsolicitedNotification());
        System.out.println("Sucessfully subscribed to statistic.");
    }

   //unsubscribe to a statistic and releases the reference.
    public void unsubscribe()throws Exception{

       //Unsubscribe Statistic
        statPort.unsubscribeStatistic("statref1");
        System.out.println("Unsubscribed to statistics.");
    }

    //Standalone option to test run this example.
    //Creates a new instance of this object and starts the process.
    public static void main(String[] args) {

        try{
          SubscribeToStatisticExample sb = new SubscribeToStatisticExample();
          sb.subscribe("localhost:9090");
          sb.unsubscribe();
        } catch (Exception serviceException) {
            System.out.println(serviceException.getMessage());
        }
    }
}