/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.statExamples;

import gis.sessExamples.*;
import gis.services.statistic.StatService;
import gis.services.statistic.StatServiceServiceLocator;
import gis.services.statistic.StatServiceSoapBindingStub;
import gis.services.statistic.*;

import javax.xml.rpc.ServiceException;
import java.rmi.RemoteException;


/**
 * This example demonstrates how to retrieve Statistic profiles in Configuration Management
 * The items returned include statistic names, time range, and time profile.
 *
 * Date: March 25, 2003
 *
 */

public class RetrieveStatisticalProfileExample {

    public RetrieveStatisticalProfileExample() {}


    /*
     * This method uses ConnectToService to login and check out the license to the statistic service.
     * Then it retrieves the statistic profiles as seen under the Option tab,
     * in the stat server application object in Configuration Management.
     *
     * @param targetHost <gis_host>:<gis_port>
     */
    public void execute(String targetHost) throws Exception {

        StatService port_stat;
        String url_stat = "";
        String[] services = {"GIS_STATSERVICE"};

        ConnectToServiceExample cs = new ConnectToServiceExample(services);
        cs.execute(targetHost);

        //create a new proxy instance.
        StatServiceServiceLocator service_stat = new StatServiceServiceLocator();
        port_stat = service_stat.getStatService();
        url_stat = "http://" + targetHost +
"/gis/services/StatService?GISsessionId=" + cs.sid;
//Bind stat address endpoint
        ((StatServiceSoapBindingStub)
port_stat)._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
url_stat);


        //---------------------------------------------------------------
        //Retrieve statistical profiles request
        //---------------------------------------------------------------

        RetrieveStatisticalProfileResponse statistic_profile = port_stat.retrieveStatisticalProfile("", StatisticalProfileType.statisticalProfile);
        System.out.println("retrieving statistic profiles.....");

 	ProfileInfo info = statistic_profile.getStatisticalProfileInfo();
        StatisticTypeInfoType[] types = info.getStatisticInfos();
        for (int i = 0; i < types.length; i++) {
            StatisticTypeInfoType infoType = types[i];
            System.out.print(infoType.getTypeName() + "( " + infoType.getType().getValue() + ") ->");
            for (int j = 0; j < infoType.getObjectTypes().length; j++) {
                ObjectType type = infoType.getObjectTypes()[j];
                System.out.print(": " + type.getValue());
            }
            System.out.println("\n----");
        }

        //retrieve filter names
        RetrieveStatisticalProfileResponse filter_profile = port_stat.retrieveStatisticalProfile("", StatisticalProfileType.filterProfile);
        System.out.println("retrieving filter profiles.....");

	ProfileInfo info1 = filter_profile.getStatisticalProfileInfo();
        Parameter[] filter = info1.getFilters();
        if (filter != null)
          for (int i =0;i<filter.length; i++)
           System.out.println("Key= " + filter[i].getKey() + "  Value= " + filter[i].getValue());

        //retrieve time profile names
        RetrieveStatisticalProfileResponse time_profile = port_stat.retrieveStatisticalProfile("", StatisticalProfileType.timeProfile);
        System.out.println("retrieving time profiles.....");

	ProfileInfo info2 = time_profile.getStatisticalProfileInfo();
        TimeProfile[] timeProf = info2.getTimeProfiles();
        if (timeProf != null)
         for (int i =0;i<timeProf.length; i++){
           System.out.print("Key = " + timeProf[i].getKey() + "  Value = " + timeProf[i].getValue());
           System.out.println("  time interval = " + timeProf[i].getIntervalType().getValue());
        }

        //retrieve time range names
        RetrieveStatisticalProfileResponse timerange_profile = port_stat.retrieveStatisticalProfile("", StatisticalProfileType.timeRangeProfile);
 	System.out.println("retrieving time range profiles.....");

        ProfileInfo info3 = time_profile.getStatisticalProfileInfo();
        Parameter[] timeRange = info3.getTimeRanges();
        if (timeRange != null)
          for (int i =0;i<timeRange.length; i++)
           System.out.println("Key = " + timeRange[i].getKey() + "  Value = " + timeRange[i].getValue());

        System.out.println("logging out of session...");

        //logout request
        cs.port.logout(cs.sid);
    }

    //Standalone option to test run this example. Creates a new instance of this object and starts the process
    public static void main(String[] args) {
        try {
            RetrieveStatisticalProfileExample example = new RetrieveStatisticalProfileExample();
            example.execute("localhost:9090");
        } catch (Exception serviceException) {
            System.out.println("error occured: " + serviceException.getMessage());
        }
    }
}