/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gisNotification ;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.net.URL;
import java.util.*;
import java.io.*;

/*
 * This class demonstrates a server side code based on the GIS notification.wsdl file.
 * The example's version of the notify() method accepts notification of statistic or configuration requests.
 * Then it stores the data into a static hashtable. The retrieveMessage() method demonstrates a simple implementation
 * of how a remote agent desktop client can receive these published GIS data via it own client HTTP server.
 *
 * @date Feb 4, 2004
 *
 *
 * This class is what we are publishing. The notify() method is published
 * based on the notification.wsdl file. The service needs to be deployed using the deploy.wsdd file
 *
 * Before you start, make sure the Tomcat\Axis is running. Take note on the port it is running on.
 * You may need to change the port in any affected steps below:
 *
 * To publish the java file:
 *
 *  1) create a wsdl to describe it (optional)
 *
 *  2) Create a wsdd deployment file. (see deploy.wsdd gisNotification)
 *
 *  3) go to directory <Your_tomcat_home>\webapps\axis\gisNotification
 *
 *  4) modify and run the setAxisPath.bat (Window) or setAxisPath.sh (Unix) provided.
 *
 *  5) type the following (all on one line) from <Your_tomcat_home>\webapps\axis\gisNotification directory:
 *
 * 	Windows:
 *      java -cp %AXISCLASSPATH% org.apache.axis.client.AdminClient
 *		-lhttp://<your_Tomcat_HostName>:<your_Tomcat_Port>/axis/services/AdminService deploy.wsdd
 *
 *  	Unix:
 *	java -cp $AXISCLASSPATH org.apache.axis.client.AdminClient
 *		-lhttp://<your_Tomcat_HostName>:<your_Tomcat_Port>/axis/services/AdminService deploy.wsdd
 *
 *
 *  6) You should see the result like this:
 *
 *    Apr 15, 2003 3:29:58 PM org.apache.axis.client.AdminClient process
 *    INFO: Processing file deploy.wsdd
 *    Apr 15, 2003 3:29:59 PM org.apache.axis.client.AdminClient main
 *    INFO: <Admin>Done processing</Admin>
 *
 *  7) You should immediately check the server-config.wsdd file. This is the Axis service
 *     deployment config file. You should see your newly deployed service entry in there.
 *     If not, your service did not deploy properly.
 *
 *  8) When you see your service entry in the server-config.wsdd file, open IE and test the service:
 *        http://<your_Tomcat_HostName>:<your_Tomcat_Port>/axis/services/notification
 *
 *     You should see a simple message about the service like below:
 *
 *		notification
 *		Hi there, this is an AXIS service!
 *
 *		Perhaps there will be a form for invoking the service here...
 *
 *
 *     You should also check the wsdl for the service URL:
 *
 *         http://<your_Tomcat_HostName>:<your_Tomcat_Port>/axis/services/notification?wsdl
 *
 *   9) When you get to this step, you can try a client application, such as UnsolicitedNotificationExample.java,
 *	to invoke the unsolicited request with your Tomcat URL above. You should see an output similar to the one
 *	below in Tomcat Server console window:
 *
 *          Hello from gis notification service
 *          event type StatisticNotification
 *          key val sessionId
 *          key val SessionService:1052416370233H17
 *          key val statId
 *          key val statref1
 *          key val date
 *          key val 1052416688
 *          key val intervalLength
 *          key val 885
 *          key val lValue
 *          key val 665
 *
 *
 */


public class NotifyService {

  private static Hashtable messages = new Hashtable();

/*
 * This method's signature follows the requirement set by the GIS notification.wsdl file.
 * Note: You cannot modify the signature, otherwise the notification service will not work.
 *
 * You can modify the code. This example below stores the data received from GIS into the cache
 * via a hastable. This is only a suggestion of how you can store the data. Alternatively, you can
 * write code to store information in a database or file.
 *
 */

  public void notify(String eventType, String[][] keyVal) {

    System.out.println("Hello from gis notification service");
    System.out.println("event type " + eventType);

    for(int i=0; i<keyVal.length;i++)
      for(int j=0;j<keyVal[0].length;j++){
        System.out.println("key val " + keyVal[i][j]);
        if (keyVal[i][j].indexOf("SessionService") != -1)   //contains session id
           messages.put(keyVal[i][j],keyVal);               //store (and overwrite) each session's message using its sid as key value
      }
  }


/*
 * This method is NOT part of the GIS notification.wsdl specification. It's purpose is to demonstrate
 * that you can deploy a user-defined interface in the *same* notification service to retrieve the data
 * stored by the notify() method above. This is just one of many ways to retrieve the data stored.
 * Note: You do not need to deploy a user-service to retrieve stored data. A desktop client can access
 * a database or flat file. A web client that cannot or should not access database or file system
 * can benefit from this solution.
 *
 * In the sample deploy.wsdd file provided, note that the 'allowedMethods' parameter value is set to '*'.
 * This setting allows any method defined in this class to be published as an interface.
 * The extra API or interface in the service is called 'retrieveMessage'. You can see it when you go to your URL:
 * http://<your_tomcat_hostName>:<your_tomcat_port>/axis/services. The page lists all the deployed services
 * with the interface exposed.
 *
 */

  public String retrieveMessage(String sid){
    try{
    // PrintWriter out = new PrintWriter(new FileOutputStream("C:\\<TomcatHome>\\logs\\test.txt")); //debugging only

     System.out.println("sid= " + sid);
     String[][] msgArray = (String[][])messages.get(sid);
     String msg = new String();

     while (msgArray == null) {
        System.out.println("Waiting to receive information for this session id.");
        msgArray = (String[][])messages.get(sid);
     }

     //flatten the array into a string for ease of demonstration.
     for(int i=0; i<msgArray.length;i++)
        for(int j=0;j<msgArray[0].length;j++) {
          if (j%2 == 1)
            msg = msg + " = " + msgArray[i][j] + "\n";
          else
            msg = msg + msgArray[i][j];
        }
     return msg;
    }catch(Exception e){return null;}
  }

}
