/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/* ---------------------------------------------------------------------------------- 	*/
/*                                                                                    	*/
/* File  : UpdateConfigurationDataExample.java                                          */
/* Title : Example demonstrating work with Configuration Service                       	*/
/*                                                                                    	*/
/*                                                                                    	*/
/* Content : This example explains how to accomplish Configuration Service [update]    	*/
/* requests by uploading a XML data file						*/
/* and showing processing of the results of the request.                              	*/
/* ---------------------------------------------------------------------------------- 	*/

package gis.cfgExamples;

import java.io.*;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;

import gis.services.csproxy.*;

public class UpdateConfigurationDataExample {

  // Connection parameters used to connect and register at GIS and Configuration Service

   String gisPrincipal    = "default";
   String gisCredentials  = "password";
   String cfgUserName     = "default";
   String cfgUserPassw    = "password";
   String cfgAppName      = "default";

   static String sampleFile = "sample_01.xml"; //default

    // set of XML data files composing a sequence of updates
   String dataFile    = "gis/cfgExamples/data/" + sampleFile;   // the xml is stored in a separate file for readability


   /*
    * execute method - accomplishes all the sample's application logic
    */

   public void execute(String gisServer) throws Exception {

       //this class provides functionality to subscribe to, unsubscribe to, release and logout from the GIS configuration service
      RegisterToConfigurationServiceExample subConfig = new RegisterToConfigurationServiceExample();
      subConfig.register(gisServer);	//subscribe to GIS configuration service

        // parse the xml data
      javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
      org.w3c.dom.Document xmlDocument = documentBuilder.parse(dataFile);

        // prepare data
      CSXmlData updateData = new CSXmlData();
      MessageElement messageElement = new MessageElement(xmlDocument.getDocumentElement());
      MessageElement[] any = new org.apache.axis.message.MessageElement[] { messageElement };
      updateData.set_any(any);

        // call update method
      System.out.print("==>Updating configuration using " + dataFile + " ...");
      CSResult updateResponse = subConfig.configPort.update(updateData);
      System.out.println("done \n");

        // print results of the call
      System.out.println("==>Update result:");
      for (int j=0; j < updateResponse.get_any()[0].getChildren().size(); j++) {

         MessageElement elem = (MessageElement)updateResponse.get_any()[0].getChildren().get(j);

           // get errorInfo element
         MessageElement errorInfo = (MessageElement)elem.getChildElements().next();

         if (errorInfo.getAttributeValue("returnCode").equals("0"))
             System.out.println(" Item : id [" + elem.getAttributeValue("id") + "] processed successfully");

         else{
               // read serverErrorInfo element
            MessageElement serverErrorInfo = (MessageElement)errorInfo.getChildElements().next();
              // read description element
            MessageElement description = (MessageElement)serverErrorInfo.getChildElements().next();
            System.out.println(" Item : id [" + elem.getAttributeValue("id") + "] processed with error : " +
                             description.getValue());
         }
      }
      System.out.println("\n");   //writes a newline char. Makes it easier to read the console output.
      subConfig.releaseAndLogout();
   }


   // The main entry point for the application.
   public static void main (String args[])  throws Exception {

      UpdateConfigurationDataExample example = new UpdateConfigurationDataExample();
      example.execute("<hostName:port>");
   }

}
