/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/* ---------------------------------------------------------------------------------- */
/*                                                                                    */
/* File : UnsolicitedNotificationExample.java                                         */                     /*										      */
/* Title : Example demonstrating work with Configuration Service                       */
/*                                                                                    */
/*                                                                                    */
/* Content : This example explains how to work with Configuration Service notification */
/* mechanism by using unsolicited notifications.                                      */
/* ---------------------------------------------------------------------------------- */

package gis.cfgExamples;

import java.io.*;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;

import gis.services.session.*;
import gis.services.csproxy.*;

import java.util.Iterator;


public class UnsolicitedNotificationExample
{
  /// Connection parameters used to connect and register at GIS and Configuration Service

  String gisPrincipal    = "default";
  String gisCredentials  = "password";
  String cfgUserName     = "default";
  String cfgUserPassw    = "password";
  String cfgAppName      = "default";


  /// Run method - accomplishes all the sample's application logic
  void execute(String targetHost) throws Exception  {

    // Create a session service
    GISSessionService sessionService = new GISSessionServiceLocator();
    SessionServicePortType sessionPort = sessionService.getSessionService(new java.net.URL("http://" + targetHost + "/gis/services/SessionService"));

    // Login at the Session Service
    System.out.print("==>Connecting and registering at Configuration Service using [" + targetHost + "] ...");
    Identity identity = new Identity();
    identity.setPrincipal(gisPrincipal);
    identity.setCredentials(gisCredentials);
    identity.setTenant("");
    String sid = sessionPort.login(identity);

    // Change the URL at session service (include SID)
    sessionPort = sessionService.getSessionService(new java.net.URL("http://" + targetHost + "/gis/services/SessionService?GISsessionId=" + sid));

    // Check in Config Service license
    String[] services = new String[]{"GIS_CONFIGSERVICE"};
    sessionPort.getServices(services);

    // Create Configuration Service
    GCELocator configService = new GCELocator();
    configService.setMaintainSession(true);
    GCESoapPort configPort = configService.getGCESoapPort(new java.net.URL("http://" + targetHost + "/gis/services/CSProxyService?GISsessionId=" + sid));

    // set the engine option which will prevent from putting 'multiRef' elements in the method parameters
    configService.getEngine().setOption(org.apache.axis.AxisEngine.PROP_DOMULTIREFS,Boolean.FALSE);

    // Register at the Configuration Service
		configPort.register(cfgUserName,cfgUserPassw,cfgAppName);
    System.out.println("done");

    // Get the Configuration Service version
    System.out.println("==>Configuration Service version is ..." +
                       configPort.getVersion());


    // subscribe on notifications on Skills
    javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
    javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    org.w3c.dom.Document xmlDocument = documentBuilder.newDocument();
    org.w3c.dom.Element  subscriptionData = xmlDocument.createElement("subscriptionData");
    org.w3c.dom.Element  subscription = xmlDocument.createElement("subscription");
    subscription.setAttribute("type","CfgSkill");
    subscriptionData.appendChild(subscription);
    xmlDocument.appendChild(subscriptionData);

    CSSubscriptions subscriptions = new CSSubscriptions();
    MessageElement messageElement = new MessageElement(xmlDocument.getDocumentElement());
    MessageElement[] any = new org.apache.axis.message.MessageElement[] { messageElement };
    subscriptions.set_any(any);

    System.out.println("==>Subscription on notifications completed ..." +
                       configPort.subscribeEx(subscriptions,"http://<clientHost>:<port>/axis/services/cfgNotification",""));
    Thread.currentThread().run();

  }

  /// The main entry point for the application.
  public static void main (String args[])  throws Exception  {

    UnsolicitedNotificationExample test = new UnsolicitedNotificationExample();
    test.execute("<hostname:port>");
  }
}
