/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/
/* ---------------------------------------------------------------------------------- */
/*                                                                                    */
/* File : GetConfigInformation.java                                                   */
/* Title : Example demonstrating work with Configuration Service                      */
/*                                                                                    */
/*                                                                                    */
/* Content : This example explains how to accomplish Configuration Service [get]      */
/* requests, demonstrating usage of different kinds of XPath expressions and showing  */
/* processing of the results of such queries.                                         */
/* ---------------------------------------------------------------------------------- */

package gis.cfgExamples;

import java.io.*;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;



public class GetConfigurationInformationExample {


   public GetConfigurationInformationExample(){}

  /*
   * The following section defines the queries used to retrieve Configuration information.
   * The queries are based on the Configuration Server schema definition and in xpath format.
   * For more information on how to construct the queries,
   * see 6.5 Configuration SDK Reference Manual and 6.5 Configuration SDK Developer's Guide.
   */

  // get all Agents
  String queryAllAgents     = "CfgAgent";

  // get Agent Groups where specific agent participates
  String queryAgentGroupsAlt   = "CfgAgent[@name='Agent0']/agentGroups/*/baseDBID";
  String queryAgentGroups= "CfgAgentGroup[agentDBIDs/*/linkDBID/@name='Agent0']";

  // get all Agents from some Agent Group
  String queryAgents        = "CfgAgentGroup[@name='Agent Group 1']/agentDBIDs/*/linkDBID";
  String queryAgentsAlt     = "CfgAgent[agentGroups/*/baseDBID/@name='Agent Group 1']";

  // get all Skills for some Agent
  String querySkills        = "CfgAgent[@name='Agent1']/skillLevels/*/linkDBID";

  // get all Switches connected to some Agent (through its Login)
  String querySwitches      = "CfgAgent[@name='Agent1']/agentLogins/*/linkDBID/ownerDBID";

  // get all Agents assigned to a particular Place
  String queryAgentsByPlace = "CfgAgent[placeDBID/@name='Place0']";

  // get all Places which don't have assigned Agents
  String queryPlacesWoAgents= "CfgPlace[not agents]";

  // get the all DNs of type 'ACD Position' under some Switch
  String queryDNs           = "CfgSwitch[@name='SwitchG3_Test']/DNs/CfgDN[@type='2']";

  // get all the Agents under some Folder
  String queryAgentsByFolder= "CfgFolder[@name='SubFolder']/objectIDs/CfgPersonShortcut/linkDBID";


  /*
   * This method creates a session, logs into a GIS server, and subscribes to the licensed services.
   * The get() method from the GCESoapPort class will process the queries and return configuration data in xml format.
   *
   * @throws Exception
   */

  public void execute(String targetHost) throws Exception{

     //this class provides functionality to register, unsubscribe, release and log out from the GIS configuration service
    RegisterToConfigurationServiceExample subConfig = new RegisterToConfigurationServiceExample();
    subConfig.register(targetHost);	//register to GIS configuration service

    // Get the configuration service version
    System.out.println("==>Configuration service version is ..." +
                       subConfig.configPort.getVersion());

    // read information about all the agents
    displayResults(queryAllAgents,subConfig.configPort.get(queryAllAgents));

    // read information about all the Agent's Agent Groups
    displayResults(queryAgentGroups,subConfig.configPort.get(queryAgentGroups));

    // read information about all the Agents from some Agent Group
    displayResults(queryAgents,subConfig.configPort.get(queryAgents));

    // read information about all the Skills for some Agent
    displayResults(querySkills,subConfig.configPort.get(querySkills));

    // read information about all the Switches for some Agent
    displayResults(querySwitches,subConfig.configPort.get(querySwitches));

    // read information about all the Agents assigned to a particular Place
    displayResults(queryAgentsByPlace,subConfig.configPort.get(queryAgentsByPlace));

    // read information about all the Places without assigned Agents
    displayResults(queryPlacesWoAgents,subConfig.configPort.get(queryPlacesWoAgents));

    // read information about all the DNs of type 'ACD Position' under some Switch
    displayResults(queryDNs,subConfig.configPort.get(queryDNs));

    // read information about all the Agents under some Folder
    displayResults(queryAgentsByFolder,subConfig.configPort.get(queryAgentsByFolder));

    System.out.println("\n");   //writes a newline char. Makes it easier to read the console output.
    subConfig.releaseAndLogout();

  }


  /*
   * This method displays results of the queries.
   * The query result structure returns MessageElement objects reflecting the update schema structure.
   *
   * @param query	The query to pass into Configuration Server to retrieve configuration data.
   * @param result	The result of the query.
   */

  void displayResults(String query,gis.services.csproxy.CSResult result) {

     if (result.get_any()[0].getChildren() != null) {

        System.out.println("\n");   //writes a newline char. Makes it easier to read the console output.
        System.out.println("Result for query '" + query + "'");
        for (int i=0; i < result.get_any()[0].getChildren().size(); i++) {
           MessageElement elem = (MessageElement)result.get_any()[0].getChildren().get(i);
           System.out.println(" =>Object type is = '" + elem.getName() + "' Object name is = '" + elem.getAttributeValue("name") + "'");
        }

     }else{
        System.out.println("\n");   //writes a newline char. Makes it easier to read the console output.
        System.out.println("Results for query '" + query + "'" );
        System.out.println(" => No data available");
     }
  }


  /*
   * Standalone option to test run this example.
   * The main() method creates a new instance of this object and starts the process.
   */

  public static void main (String args[])  throws Exception {

    GetConfigurationInformationExample configInfo = new GetConfigurationInformationExample();
    configInfo.execute("HOST_NAME:PORT");

  }

}
