/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.configuration;

import org.apache.axis.message.MessageElement;

import com.genesyslab.gis.services.configuration.types.CSSubscriptions;
import com.genesyslab.gis.services.session.ConnectSessionServiceExample;
import com.genesyslab.gis.util.NotificationModule;
import com.genesyslab.gis.util.PropertiesLoader;

public class UnsolicitedNotificationExample {
	// / Connection parameters used to connect and register at GIS and
	// Configuration Service

	String gisPrincipal = "default";
	String gisCredentials = "password";
	String cfgUserName = "default";
	String cfgUserPassw = "password";
	String cfgAppName = "default";

	String[] services = new String[] { "GIS_CONFIGSERVICE" };
	public ConnectSessionServiceExample cs;

	// / Run method - accomplishes all the sample's application logic
	void execute(String gisServer) throws Exception {

		cs = new ConnectSessionServiceExample(services);
		cs.execute(gisServer);

		String cfgUserName = "default";
		String cfgUserPassw = "password";
		String cfgAppName = "default";

		// Connection parameters used to connect and register at GIS and
		// Configuration Service

		// Create Configuration Service

		// Create Configuration Service
		GCELocator configService = new GCELocator();
		configService.setMaintainSession(true);
		GCESoapPort configPort = configService
				.getGCESoapPort(new java.net.URL("http://" + gisServer
						+ "/gis/services/CSProxyService?GISsessionId=" + cs.sid));

		// set the engine option which will prevent from putting 'multiRef'
		// elements in the method parameters
		configService.getEngine().setOption(
				org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);

		// Register at the Configuration Service
		configPort.register(cfgUserName, cfgUserPassw, cfgAppName);
		System.out.println("done");

		// Get the Configuration Service version
		System.out.println("==>Configuration Service version is ..."
				+ configPort.getVersion());

		// Start the Notification Service used to retrieve notification Events
		NotificationModule.getInstance().start();

		// subscribe on notifications on Skills
		javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory
				.newInstance();
		javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory
				.newDocumentBuilder();
		org.w3c.dom.Document xmlDocument = documentBuilder.newDocument();
		org.w3c.dom.Element subscriptionData = xmlDocument
				.createElement("subscriptionData");
		org.w3c.dom.Element subscription = xmlDocument
				.createElement("subscription");
		subscription.setAttribute("type", "CfgSkill");
		subscriptionData.appendChild(subscription);
		xmlDocument.appendChild(subscriptionData);

		CSSubscriptions subscriptions = new CSSubscriptions();
		MessageElement messageElement = new MessageElement(xmlDocument
				.getDocumentElement());
		MessageElement[] any = new org.apache.axis.message.MessageElement[] { messageElement };
		subscriptions.set_any(any);
		String gisHost = PropertiesLoader.getOption("gis.host");
		String notificationPort = PropertiesLoader
				.getOption("client.notification.port");
		System.out.println("==>Subscription on notifications completed ..."
				+ configPort.subscribeEx(subscriptions, "http://" + gisHost
						+ ":" + notificationPort
						+ "/axis/services/notification", ""));

		Thread.currentThread().run();

	}

	// / The main entry point for the application.
	public static void main(String args[]) throws Exception {
		String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
		UnsolicitedNotificationExample test = new UnsolicitedNotificationExample();
		test.execute(gisHost + ":" + gisPort);
	}
}
