/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.IO;
using System.Xml;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

/* NotifyService is the callback class used for Notification from Configuration Server
 * 
 */
public class NotifyService : MarshalByRefObject
{         
	private void DisplayNotification(XmlElement cfgData,string elementName,string textStr)
	{
		XmlElement operElem = cfgData[elementName];
		if (operElem != null && operElem.ChildNodes.Count > 0)
		{
			Console.WriteLine(" ===>" + textStr + ":");
			foreach (XmlElement elem in operElem.ChildNodes)
				Console.WriteLine("  Object [{0}], DBID [{1}], name [{2}]",
					elem.Name,elem.GetAttribute("DBID"),elem.GetAttribute("name"));
		}
	}

	public void notifyInitMessage(string serverHost, string serverPort, string serverApp)
	{
		Console.WriteLine("Init message received from {1}:{0}, application [{2}]",serverHost,serverPort,serverApp);
	}

	public void notifyMessage(string result)
	{
		XmlDocument doc = new XmlDocument();
		doc.LoadXml(result);
		DisplayNotification(doc.DocumentElement,"CfgCreate","Created");
		DisplayNotification(doc.DocumentElement,"CfgUpdate","Updated");
		DisplayNotification(doc.DocumentElement,"CfgRemove","Removed");
	}
}

public class UnsolicitedNotificationExample
{
	int    notifyPort      = 8001;
	string notifyHost      = System.Net.Dns.GetHostName();
	string microsoftNS     = "http://schemas.microsoft.com/clr/nsassem";
	string serviceClass    = "NotifyService";
  
	public void execute(String targetHost)
	{
		try 
		{
			RegisterToConfigurationServiceExample registerExample = new RegisterToConfigurationServiceExample();
			registerExample.execute(targetHost);

			GCE cfgService = registerExample.cfgService;

			// get Configuration Service version
			Console.WriteLine("==>Configuration Service version is ..." + 
				cfgService.getVersion());

			// register channel
			HttpServerChannel channel = new HttpServerChannel("notifyChannel",notifyPort);
			ChannelServices.RegisterChannel(channel);
			RemotingConfiguration.RegisterWellKnownServiceType(typeof(NotifyService), "notifyService", WellKnownObjectMode.Singleton);

			XmlDocument doc = new XmlDocument();
			XmlElement subscriptionData = doc.CreateElement("","subscriptionData","");
			XmlElement subscription = doc.CreateElement("","subscription","");
			subscription.SetAttribute("type","","CfgAgent");
			subscriptionData.AppendChild(subscription);
			doc.AppendChild(subscriptionData);

			// subscribe on notifications on Skills
			Console.WriteLine("==>Subscription on notifications completed ..." + 
				cfgService.subscribeEx(doc.DocumentElement,
				"http://" + notifyHost + ":"+notifyPort+"/notifyService",microsoftNS+"/"+serviceClass+"/Test9#"));

			Console.WriteLine("\n Listening for notifications ... (press Enter to finish) \n");
			Console.ReadLine();

			// now NotifyService class is responsible for processing of the notifications

			Console.WriteLine("done");
			cfgService.unregister();

		}
		catch (Exception e)
		{
			Console.WriteLine(e.Message);
		}
	}
}