/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.IO;
using System.Xml;

public class UpdateConfigurationDataExample
{
	// set of XML data files composing a sequence of updates
	string [] dataFiles    = {"sample_01.xml"};

	public void execute(String targetHost)
	{
		try 
		{
			RegisterToConfigurationServiceExample registerExample = new RegisterToConfigurationServiceExample();
			registerExample.execute(targetHost);

			GCE cfgService = registerExample.cfgService;

			// get Configuration Service version
			Console.WriteLine("==>Configuration Service version is ..." + 
				cfgService.getVersion());

			//Create object based on a xml file
			foreach (string file in dataFiles)
			{
				// read an XML document from the file
				XmlDocument doc = new XmlDocument();
				doc.Load(file);

				// call an update method
				Console.Write("==>Updating configuration using {0}...",file);
				XmlElement result = (XmlElement)cfgService.update((System.Xml.XmlElement)doc.DocumentElement);
				Console.WriteLine("done");
				// print results
				Console.WriteLine("===>Results :");
				foreach (XmlElement item in result.ChildNodes)
					if (item["errorInfo"].GetAttribute("returnCode") == "0")
						Console.WriteLine(" Item : id [{0}] processed successfully",item.GetAttribute("id"));
					else
						Console.WriteLine(" Item : id [{0}] processed with error : {1}",item.GetAttribute("id"),
							item["errorInfo"]["serverErrorInfo"]["description"].InnerText);
			}
			Console.WriteLine("done");
			cfgService.unregister();
		}
		catch (Exception e)
		{
			Console.WriteLine(e.Message);
		}
	}

}
