(function(){

	/*
		Genesys Webchat Options and Initialization Script
		Version: 1.1.6
		Release Data: 2015-05-08
	*/

	// Hide console messages coming from Genesys Webchat
	var console = {log: function(){}, debug: function(){}};
    
    $(document).ready(function(){

		/*
    		-----------------------
			Genesys Webchat Options
			-----------------------

			Settings for UI, Connection, and Internationalization. See documentation for reference.

    	*/


    	var ndBody = $(document.body),
            GenesysWebChatInstance;

		var oChatOptions = {

			// Basic UI Settings
			mode:	  "overlay",
			template: "#genesys_webchat",

			// Connection Settings
            transport:  "eliza",
            id:         "1234567890",
            dataURL:    "http://your_apigee_domain/api/v2/chats",
            CSRFURL:	"http://your_apigee_domain/api/v2/diagnostics/version",

			// Default userData (you can override this per-page by setting window.oChatOptions.userData before starting a chat)
            userData: {

                SkillName: ""
            },

             // Internationalization Settings
            i18n_lang:			"en",
            i18n_URL:			"genesys-webchat-i18n.json",
            i18n_messages:		false,

            // Popup Window Settings
            popupChatWindowHREF:  "genesys-webchat-window.html",
            popupChatWindowOptions: 'width=420, height=' + screen.height + ', top=0, left=' + (screen.width - 420)
        };


        window.getGenesysWebChatOptions = function(){

			return oChatOptions;
		}

		/* Append The overlay-mode HTML template and CSS style block automatically - Modify with your own customizations */
		ndBody.append(

		    "<div id='genesys_webchat' class='ChatUI OverlayMode'>"+
				"<div class='title i18n' data-message='ChatTitle'>Chat Support</div>"+
				"<div class='end i18n' data-message='ChatEnd'>End Chat</div>"+
				"<div class='close i18n' data-message='ChatClose'>Close</div>"+
				"<div class='form'>"+
					"<label><span class='i18n' data-message='ChatFormFirstName'>First Name</span><input name='firstname'></label>"+
                    "<label><span class='i18n' data-message='ChatFormLastName'>Last Name</span><input name='lastname'></label>"+
                    // "<label><span class='i18n' data-message='ChatFormNickname'>Nickname</span><input name='nickname'></label>"+
                    // "<label><span class='i18n' data-message='ChatFormSubject'>Subject</span><input name='subject'></label>"+
                    "<label><span class='i18n' data-message='ChatFormEmail'>Email</span><input name='email'></label>"+
					"<button class='submit i18n' data-message='ChatFormSubmit'>Start Chat</button>"+
				"</div>"+
				"<div class='transcript'></div>"+
				"<div class='input-container'>"+
					"<textarea class='input i18n' data-message='ChatInputPlaceholder' data-message-type='placeholder'></textarea>"+
					"<button class='send i18n' data-message='ChatSend'>SEND</button>"+
				"</div>"+
				"<div class='isTyping'></div>"+
			"</div>"
		);

		ndBody.append(

			"<style type='text/css'>"+
				".ChatUI.OverlayMode{display:none;height:400px;background-color:white;position:fixed;right:0;bottom:0;width:400px;-webkit-box-shadow: 0px 2px 10px 4px #8A8A8A;box-shadow: 0px 2px 10px 4px #8A8A8A}"+
				".ChatUI.OverlayMode .transcript{padding:5px 20px;box-sizing:border-box;overflow-y:auto;font-size:13px;line-height:18px;display:none;height:222px}"+
				".ChatUI.OverlayMode .close{display:none;color:#fff;line-height:41px;text-align:right;height:40px;position:absolute;top:12px;right:20px;-webkit-transition:	opacity .22s ease-in-out;-moz-transition:opacity .22s ease-in-out;-o-transition:opacity .22s ease-in-out;transition:opacity .22s ease-in-out;display:none}"+
				".ChatUI.OverlayMode .close:hover{cursor:pointer;opacity:.8}"+
				".ChatUI.OverlayMode .close:hover{opacity:1}"+
				".ChatUI *{box-sizing:border-box}"+
				".ChatUI{height:100vh;box-sizing:border-box;width:100%;font-family:Helvetica, Arial, sans-serif;font-size:14px;position:relative}"+
				".ChatUI .title{background-color:#CCC;width:100%;height:64px;font-size:20px;color:white;padding:22px}"+
				".ChatUI .transcript{padding:5px 20px;box-sizing:border-box;overflow-y:auto;font-size:13px;line-height:18px;display:none}"+
				".ChatUI .transcript p{word-wrap:break-word;margin:0 0;display:none;box-sizing:border-box;border-bottom:1px solid #eee;padding:1em 0}"+
				".ChatUI .transcript p.system{color:rgb(153,153,153);float:none;background:none}"+
				".ChatUI .transcript p.system .name{display:none}"+
				".ChatUI .transcript .name{display:block;font-size:11px;font-weight:bold;color:#222}"+
				".ChatUI .transcript .them{width:100%;text-align:left;float:left;clear:both;color:#2293f9}"+
				".ChatUI .transcript .them .name{}"+
				".ChatUI .transcript .you{width:100%;float:right;clear:both;color:#133ba3}"+
				".ChatUI .transcript .you .name{}"+
				".ChatUI .isTyping{color:#222;font-size:11px;position:absolute;bottom:114px;background:#e5e5e5;width:100%;padding:1em;display:none}"+
				".ChatUI .input{width:100%;height:100%;box-sizing:border-box;border-top-left-radius:0px;border-top-right-radius:0px;border-bottom-right-radius:3px;border-bottom-left-radius:3px;border:1px solid rgb(204,204,204);resize:none;padding:10px;overflow:auto;font-family:Helvetica, Arial, sans-serif;font-size:13px;line-height:16px}"+
				".ChatUI .input.disabled{opacity:0.5}"+
				".ChatUI .input-container{height:114px;padding:5px;background:#eceded;border-top:1px solid #cccccc;box-sizing:border-box;display:none}"+
				".ChatUI .form{padding:20px;overflow-y:auto;overflow-x:hidden}"+
				".ChatUI .form .welcome{width:288.5px;height:43px;margin:.5em 0 1.5em 0}"+
				".ChatUI .form label{display:block;font-size:13px}"+
				".ChatUI .form label span{display:inline-block;margin-bottom:.4em}"+
				".ChatUI .form label input{font-family:Helvetica, Arial, sans-serif;width:100%;display:inline-block;box-sizing:border-box;border-top-left-radius:3px;border-top-right-radius:3px;border-bottom-right-radius:3px;border-bottom-left-radius:3px;border:1px solid rgb(187,187,187);height:43px;font-size:14px;padding:5px;margin:0 0 1.15em 0}"+
				".ChatUI .form label input[name=email]{margin-bottom:.5em}"+
				".ChatUI .form label input.error{border-color:red}"+
				".ChatUI .form .submit{width:100%;height:32px;box-sizing:border-box;border-top-left-radius:3px;border-top-right-radius:3px;border-bottom-right-radius:3px;border-bottom-left-radius:3px;border:none;margin-top:11px;background-color:rgb(238,238,238)}"+
				".ChatUI .form .label_disclaimer{font-size:12px;line-height:16px;color:#7f7f7f;margin-bottom:1em}"+
				".ChatUI .form .form_disclaimer{font-size:12px;line-height:16px;color:#222}"+
				".ChatUI .form button.submit{font-family:Helvetica, Arial, sans-serif;font-size:16px;color:#fff;height:45px;line-height:45px;margin-bottom:1em;background-color:rgba(34,147,249,1);-webkit-transition:background-color .22s ease-in-out;-moz-transition:background-color .22s ease-in-out;-o-transitionbackground-color .22s ease-in-out;transition:background-color .22s ease-in-out}"+
				".ChatUI .form button.submit:hover{cursor:pointer;background-color:rgba(34,147,249,.8)}"+
				".ChatUI .end{color:#fff;line-height:41px;text-align:right;height:40px;position:absolute;top:12px;right:20px;-webkit-transition:opacity .22s ease-in-out;-moz-transition:opacity .22s ease-in-out;-o-transition:opacity .22s ease-in-out;transition:opacity .22s ease-in-out;display:none}"+
				".ChatUI .end:hover{cursor:pointer;opacity:.8}"+
				".ChatUI .end:hover{opacity:1}"+
				".ChatUI .send{display:none}"+
				".ChatUI .settings-group{display:none}"+
				".ChatUI .transcript > p:last-child{margin-bottom:25px}"+
			"</style>"
		);

		/*
    		----------------------------
			END: Genesys Webchat Options
			----------------------------
    	*/






















        
        


        /*
    		-------------------------------------------------------
			Basic Proactive Engagement Logic and Chat Instantiation
			-------------------------------------------------------

			This logic controls activity on the page. You may use this as-is or customize to taste.

    	*/


    	/*
    		------------------------------------------------
			Append Basic Proactive Engagement HTML Templates
			------------------------------------------------

			Appends the Chat Button, the Chat Invitation Screen, and CSS Styles for Basic Proactive Engagement.

			The template and CSS below are generic. The customer is free to customize these as they see fit. 
			Note: Do no change the IDs of these elements unless absolutely needed. If you change them here, you
			must also change the IDs being referencex in the code later on in this file.

    	*/

		/* Append floating chat icon into page - Modify img src to point to actual image location or use your own HTML. Maintain IDs and Classnames */
        ndBody.append(

            '<div id="floating_chat_button">'+
            	'<img src="img/chat-button-1.png" class="chat-button-small"/>'+
            '</div>'
        );

        /* Append Chat invite popup into page - Modify img src to point to actual image location or use your own HTML. Maintain IDs and Classnames */
        ndBody.append(

            '<div id="chat_invitation_overlay">'+
	            '<img src="img/chat-proactive-1.png" class="chat-proactive-button" usemap="#proactive_map"/>'+
	            '<map name="proactive_map">'+
		            '<area shape="rect" coords="23,104,228,143" class="Accept" alt="Live Chat" href="#" style="cursor:pointer"/>'+
		            '<area shape="rect" coords="292,174,358,216" class="Decline" alt="Live Chat" href="#" style="cursor:pointer"/>'+
	            '</map>'+
            '</div>'
        );

        /* Append Chat Buttons and Invite UI Styles - Modify as needed*/
        ndBody.append(

            "<style>"+
	            "#floating_chat_button{width:76px;height:110.5px;position:fixed;right:0px;top:250px;cursor:pointer}"+
	            "#chat_invitation_overlay{display:none;width:358px;height:216.5px;position:fixed;right:0;top:200px}"+
	            "#chat_invitation_overlay > img,#floating_chat_button>img{width:100%;height:100%}"+
            "</style>"
        );



		var Flags = {

            ShowInvite:         true,
            TrackMouseIdle:     true
        },

        Timers = {

            ChatInvite: null,
            ChatInviteMouseIdle: null,
            ChatInviteDelay: 5000
        },

        HTML = {

            FloatingChatButton:     $("#floating_chat_button"),
            ChatInviteOverlay:      $("#chat_invitation_overlay"),
            ChatInviteAccept:       $("#chat_invitation_overlay .Accept"),
            ChatInviteDecline:      $("#chat_invitation_overlay .Decline")
        };

	    // Override Defaults - Customize if needed
	    function updateOptions(){

		    if(window.oChatOptions){

	    		var oOverride = window.oChatOptions;

	    		if(oOverride.mode)oChatOptions.mode = oOverride.mode;
				if(oOverride.popupChatWindowOptions)oChatOptions.popupChatWindowOptions = oOverride.popupChatWindowOptions;
				if(oOverride.userData)oChatOptions.userData = oOverride.userData;
				if(oOverride.ChatInviteDelay >= 0)Timers.ChatInviteDelay = oOverride.ChatInviteDelay;
				if(oOverride.ShowInvite === true || oOverride.ShowInvite === false)Flags.ShowInvite = oOverride.ShowInvite;
				if(oOverride.TrackMouseIdle === true || oOverride.TrackMouseIdle === false)Flags.TrackMouseIdle = oOverride.TrackMouseIdle;
				if(oOverride.StartChatInPopup === true || oOverride.StartChatInPopup === false)Flags.StartChatInPopup = oOverride.StartChatInPopup;
				if(oOverride.i18n_lang)oChatOptions.i18n_lang = oOverride.i18n_lang;			
		    }
		}

	    // Defined by Customer - If within business hours, return true. If outside of business hours, return false
	    function checkBusinessHours(){

	        //return false;
	        return true;
	    };

	    // Defined by Customer - If user info is available (user is logged in), set the values in the object being returned. Otherwise return false
	    function getUserInfo(){

	        //return {firstname:"a", email:"a@b.c"};
	        return false;
	    };

	    // Method for showing chat button - Modify to taste
	    function showChatButton(){

	    	HTML.FloatingChatButton.show();
	    }			

	    // Method for hiding chat button - disable to prevent hiding
	    function hideChatButton(){HTML.FloatingChatButton.hide()}


	    /* 
	    /* Please Do Not modify the following code. Genesys cannot provide proper support if this code is changed by Customer
	    */
	    function getInviteCookieState(){return !!$.cookie("chatInviteFlag")}
	    function setInviteCookieState(bValue){$.cookie("chatInviteFlag", !!bValue)}


	    function openChatWindow(e){

	        e.preventDefault();

	        updateOptions();

	        clearTimeout(Timers.ChatInvite);
	        clearInterval(Timers.ChatInviteMouseIdle);
	        HTML.ChatInviteOverlay.fadeOut();

	        var formData = getUserInfo();

	        if(oChatOptions.mode == "popup"){

		        if(oChatOptions.popupChatWindowHREF && !$.cookie("chatWindowID")){

		            var popupChatWindowOptions = oChatOptions.popupChatWindowOptions||('width=420, height=' + screen.height + ', top=0, left=' + (screen.width - 420)),
		                popupChatWindowHREF = oChatOptions.popupChatWindowHREF+"?options="+encodeURIComponent(JSON.stringify(oChatOptions)),
		                ndPopUpWindow = window.open(popupChatWindowHREF, 'popupChatWindow', popupChatWindowOptions);

		            ndPopUpWindow.focus();
		        }

		    }else if(oChatOptions.mode == "overlay"){
	        	

		    	GenesysWebChatInstance.updateI18nMessages();

	        	GenesysWebChatInstance.open();

	        	GenesysWebChatInstance.onClose = function(){

	        		showChatButton();
	        	};

	        	if(oChatOptions.formData && oChatOptions.formData.firstname && oChatOptions.formData.email){
	 
	                GenesysWebChatInstance.hideForm(true);
	                GenesysWebChatInstance.startSession();
	 
	            }else{
	 
	                oChatOptions.formData = false;
	                GenesysWebChatInstance.showForm(true);
	            }

	            $("#genesys_webchat").show();
		    }

	        hideChatButton();
	    }
	    






	    updateOptions();


	    if(checkBusinessHours()){

	        HTML.FloatingChatButton.show().click(openChatWindow);
	        showChatButton();

	        if(Flags.ShowInvite && !getInviteCookieState() ){

	            if(Flags.TrackMouseIdle === true){

	                var iCountDown = Timers.ChatInviteDelay;

	                function resetTimer(){iCountDown = Timers.ChatInviteDelay}

	                Timers.ChatInviteMouseIdle = setInterval(function(){

	                    iCountDown -= 1000;

	                    if(iCountDown <= 0){

	                        HTML.ChatInviteOverlay.fadeIn();
	                        clearInterval(Timers.ChatInviteMouseIdle);
	                        $(document).off("mousemove.idle");
	                        $(document).off("keypress.idle");
	                        $(document).off("scroll.idle");
	                    }

	                }, 1000);

	                $(document).on("mousemove.idle", resetTimer);
	                $(document).on("keypress.idle", resetTimer);
	                $(document).on("scroll.idle", resetTimer);

	            }else{

	                Timers.ChatInvite = setTimeout(

	                    function(){

	                        HTML.ChatInviteOverlay.fadeIn();
	                    },

	                    Timers.ChatInviteDelay
	                );
	            }

	            HTML.ChatInviteAccept.click(function(e){

	            	e.preventDefault();

	            	openChatWindow(e);

	            	setInviteCookieState(true);
	            });

	            HTML.ChatInviteDecline.click(function(e){

	                e.preventDefault();

	                HTML.ChatInviteOverlay.fadeOut();

	                setInviteCookieState(true);
	            });

	            
	        }
	    }

	    GenesysWebChatInstance = new window.GenesysWebChat(oChatOptions);

	    GenesysWebChatInstance.onRestore = function(){

	    	if(oChatOptions.mode === "overlay"){

		    	GenesysWebChatInstance.startSession();
		    	GenesysWebChatInstance.open();
		    	hideChatButton();
		    }
	    };

	    GenesysWebChatInstance.onClose = function(){

    		showChatButton();
    	};
	});


})();
