	import {CometD} from "CometD";

	const cometd = new CometD();
	
	var cometdConnectListener = null;
	var cometdDisconnectListener = null;
	var cometdGenesysSubscription = null;

	function onCometNotification(e) {
		if (e.data != undefined && e.data.message != undefined) {
				processResponse(e.data.message);
		}
	}

	function processResponse(data) {
		logMessage("debug", "Process action: " + data._action);
		if (data._action == undefined && data._access_number == undefined) {
			// check if queue position
			if (data._position != undefined && data._position > 0) {
				$('#agent_ready_threshold_passed').text(data.agents_logged_in);
				$('#eta').text(data._eta);
				$('#position').text(data._position);
				$('#total_waiting').text(data._total_waiting);
			} else {
				logMessage("debug", "No action (" + data._action + ") received from server");
			}
		} else if (data._action == "DialNumber" || data._access_number != undefined) {
			// mobile browsers - autodial
			// desktop broswers - display and request manual dial
			var telUrl = 'tel:+1' + data._access_number;
			if (data._access_code != undefined && data._access_code != "n/a" ) {
				telUrl += ",," + data._access_code;
			}
			if (/iphone|android/i.test(navigator.userAgent)) {
				document.location.href = telUrl;
			} else {
				$('#access_number').html('<h3><a href="' + telUrl + '">+1' + data._access_number + '</a></h3>');
				if (data._access_code != undefined && data._access_code != "n/a") {
					$('#access_code').html('<h3>' + data._access_code + '</h3>');
				} else {
					$('#access_code').html("<h3>Not Required</h3>");
				}
				$.mobile.changePage('#dialNumber');
			}
		} else if (data._action.indexOf("get-dialog") == 0) {
			var serviceUrl = $('#url').val() + data._id + "/";
			gmsInterface.getDialog(serviceUrl, data._action, onResponseReceived);
		} else if (data._action.indexOf("DisplayMenu") != -1) {
			displayMenu(data._content[0]);
		} else if (data._action.indexOf("ConfirmationDialog") == 0) {
			var currentPage = $.mobile.activePage.attr('id');
			// If the current page is the home page, just display the confirmation dialog else change the page and wait until it is loaded
			// before displaying the confirmation dialog
			if(currentPage === 'home') {
				displayConfirmationMessage(data._text);
			} else {
				$.mobile.changePage('#home');
				showConfirmationDialog = true;
				confirmationMessage = data._text;
			}
		} else {
			logMessage("debug", "Unknown action (" + data._action + ") received from server");
		}
	}
	
	function displayMenu(content) {
        var message = content._group_name;
        var menuItems = "";
        var menuItem = "";
		var groupItem = "";
        for (var groupItemIndex in content._group_content) {
            groupItem = content._group_content[groupItemIndex];
            menuItem = '<li data-name="' + groupItem._user_action_url + '" method="' + groupItem._method + '">' + groupItem._label + '</li>';
            menuItems += menuItem;
        }
        logMessage("debug", menuItems);
        $.mobile.changePage("#menu");
        $('#menu_header').text(message);
        $('#menu_list').html(menuItems);
        $('#menu_list').listview('refresh');
        $('#menu_list').children('li').bind('touchstart mousedown', function(e) {
                gmsInterface.requestHttp($(this).attr("data-name"), $(this).attr("method"), {}, {}, onResponseReceived);
        });
    }
	
	function displayConfirmationMessage(message) {
        $('#confirmation_message').text(message);
        $('#confirmation_dialog').popup();
        $('#confirmation_dialog').popup("open");
    }
	
	function onResponseReceived(data) {
        logMessage("response", JSON.stringify(data));
        //data = JSON.parse("" + data);
        //logMessage ("response", JSON.stringify (data));
        if (data._id != undefined) {
            last_session_id = data._id;
        }
        processResponse(data);
    }
			
	function notifyByCometSelectionChanged(e) {
		logMessage("comet", JSON.stringify(e));
		if ($('#notify_by_comet').val() == "true") {
			var gmsUser = unescape(encodeURIComponent(userName));
				if (gmsUser == undefined || gmsUser == '') {
					alert("GMS User is required to setup GMS notifications via comet");
				} else {
						enableComet(gmsUser,$('#url').val(),onCometNotification);
				}
			} else {
					disableComet();
			}
	};

	function enableComet(gmsUser, url,onCometNotification) {
		gmsNotificationClient.cometEnabled = true;
		startCometClient(gmsUser, url,onCometNotification);
	};

	function disableComet() {
		gmsNotificationClient.cometEnabled = false;
		stopCometClient();
		gmsNotificationClient.cometConnected = false;
	};
	
	function stopCometClient() {
		if (cometdGenesysSubscription) {
			cometd.unsubscribe (cometdGenesysSubscription);
			cometdGenesysSubscription = null;
		}
		if (cometdConnectListener) {
			cometd.removeListener(cometdConnectListener);
			cometdConnectListener = null;
		}
		if (cometdDisconnectListener) {
			cometd.removeListener(cometdDisconnectListener);
			cometdDisconnectListener = null;
		}
			cometd.disconnect();
			gmsNotificationClient.cometConnected = false;
		};

	function startCometClient(gmsUser, hosturl, callbackFn) {
		try {
			if (gmsNotificationClient.cometEnabled && !gmsNotificationClient.cometConnected) {
				$.ajaxSetup({async: true});
				cometd.websocketEnabled = false;
				var cometDurl = hosturl.replace("/genesys/1/service/","/genesys/cometd");
				
				cometd.configure({
					url: cometDurl,
					logLevel: 'debug',
					requestHeaders: {
					gms_user : gmsUser
				}
				});

				cometdConnectListener = cometd.addListener("/meta/connect", function(message)
				{
					if (cometd.isDisconnected()) {
						gmsNotificationClient.cometConnected = false;
						return;
					}
					gmsNotificationClient.cometConnected = true;
						//window.console &&  console.log ("Comet (re)connected");
				});
					
				cometdDisconnectListener = cometd.addListener("/meta/disconnect", function(message)
				{
					gmsNotificationClient.cometConnected = false;
					//window.console &&  console.log( JSON.stringify( e ) );
					//window.console &&  console.log ("Comet disconnected");
				});
				
				cometd.handshake();
				cometdGenesysSubscription = cometd.subscribe("/_genesys", callbackFn);
				//$("#assigned_cid").text( cometd.clientId );
				gmsNotificationClient.cometConnected = true;
			} else {
				return false;
			}
			} catch (e) {
				alert(e);
				window.console &&  console.log ("Unable to setup comet connection:" + JSON.stringify(e));
				return false;
			}
	};
			
			
	$('#notify_by_comet').bind('change',notifyByCometSelectionChanged);