'use strict';

angular.module('timelineWorkspacePlugin', [
  'ngCookies',
  'ngResource',
  'ngSanitize',
  'ngRoute',
  'ngSanitize',
  'ark.core',
  'ark-ui-bootstrap',
  'wu.masonry',
  'angularMoment',
  'cs.timeline',
  'cs.remoteTimelineLink',
  'cs.services',
  'journey-manager',
  'cs.services.util',
  'ngAnimate',
  'csRemoteQuery',
  'timelineFilter',
  'gms.localization',
  'gridster',
  'gms.preferences',
  'gms.logger'
])

.factory('JTimeLineQuery', function($resource, $log, GLOBAL_URL, GLOBAL_PROFILE_EXTENSIONS){
  var primaryKey = '';
  var customerProperties = GLOBAL_PROFILE_EXTENSIONS.CustomerProperties;
  for(var i = 0; i < customerProperties.length; i++){
    if(customerProperties[i].primaryKey && customerProperties[i].primaryKey ==='yes'){
      primaryKey = customerProperties[i].label;
      break;
    }
  }

  if(primaryKey === ''){
    $log.error("ERROR: No Primary Key provided");
  } else {
    var url = GLOBAL_URL.CSProfileApiUrl + "/:" + primaryKey;
    return $resource (url, null, null);
  }
});
