'use strict';

angular.module('cs.timeFilter', []).directive('timeFilter', function(){
	return{
		templateUrl: 'app/modules/context-services/time-filter.html',
		restrict: 'E',
		link: function (scope) {
			scope.timeOptions = ['All', 'Active', 'Completed'];
			scope.$watchCollection(function(){return scope.dateSearch;},
				function(){
					if (scope.rawData && scope.tabData.data){
						if (scope.tabData.data.name == 'Customer ID'){
							scope.tabData.data = {'name' : 'Customer ID',
									'subheading' : scope.tabData.data.subheading,
									'hideChildren' : scope.parseItems(scope.rawData, 'Service'),
									'stroke' : ''};
							scope.tabData.data.items = scope.tabData.data.hideChildren;
						} else if (scope.tabData.data.name == 'Anonymous ID') {
							scope.tabData.data = {'name' : 'Anonymous ID',
									'subheading' : scope.tabData.data.subheading,
									'hideChildren' : scope.parseItems(scope.rawData, 'Service'),
									'stroke' : ''};
						} else {
							scope.tabData.data = scope.parseItems([scope.rawData], scope.tabData.data.type);
						}
						scope.tabData.treeData = [scope.tabData.data];
					}
				});
		}
	}
});