'use strict';

angular.module('cs.create-task', ['cs.tree', 'cs.create-service'])
.controller('TaskController', ['$scope', 'toaster', 'csApi', function($scope, toaster, csApi) {

	$scope.dateObject = {
		date: "",
		time: ""
	};
	$scope.properties = ['', 'session_id',
		'interaction_id', 'application_type',
		'application_id', 'resource_type',
		'resource_id', 'media_type',
		'est_duration', 'timestamp'
	];
	$scope.allowedKeys = [];
	$scope.propertyInputs = [];
	$scope.usedProperties = [];
	$scope.propertyValues = [];
	$scope.keyInputs = [];
	$scope.customKey = [];
	$scope.customKeyValues = [];
	$scope.inputNumber = 0;
	$scope.title = 'Add Task';
	$scope.typeTitle = 'Task Type';
	$scope.panelId = 'Task';
	$scope.valid = true;
	$scope.tz = new Date().toString().match(/(\(\w*[\s+\w+]*\)+)/g) ? new Date().toString().match(/(\(\w*[\s+\w+]*\)+)/g)[0] : '';

	$scope.startEntity = function() {
		var i;
		var jsonService = {
			'task_type': $scope.tabData.entityType
		};

		$scope.createFeedback = null;

		for (var attr in $scope.usedProperties) {
			jsonService[attr] = $scope.usedProperties[attr];
		}

		if ($scope.customKey.length > 0) 
			jsonService["customstart"] = {}; 
			
		for (i = 0; i < $scope.customKey.length; i++) {
			if ($scope.customKey[i] && $scope.customKeyValues[i]) {
				jsonService["customstart"][$scope.customKey[i]] = $scope.customKeyValues[i];
			}
		}

		if ($scope.tabData.node.type === 'State'){
			jsonService.state_id = $scope.tabData.node.state_id;
		}

		//api call to create test
		csApi.startTask($scope.baseUrl, $scope.tabData.node.service_id, jsonService).then(successCallback, errorHandler);
	};

	//callback function after cs Api call
	function successCallback (httpResponse) {
		$scope.addHttpRequestHistory(httpResponse, 'Start Task');

		if($scope.tabData.node.type === 'Service') {
			$scope.tabData.selectOnRefresh = {
				serviceId: $scope.tabData.node.service_id,
				stateId: null,
				taskId: httpResponse.data.task_id
			}
		} else{
			$scope.tabData.selectOnRefresh = {
				serviceId: $scope.tabData.node.service_id,
				stateId: $scope.tabData.node.state_id,
				taskId: httpResponse.data.task_id
			}
		}

		toaster.pop('success', 'Task created successfully');
		if ($scope.tabData.oldCustomerId && $scope.tabData.oldQueryType) {
			$scope.tabData.queryById($scope.tabData.oldQueryType, $scope.tabData.oldCustomerId);
		}
		// $scope.$apply();
	}

	function errorHandler (httpResponse) {
		toaster.pop('error', 'Failed to create task', 'Server responded with status: ' +
			httpResponse.status + ' (' + httpResponse.statusText + ')');
		$scope.valid = false;
		$scope.addHttpRequestHistory(httpResponse, "Start Task");
	}
	
	$scope.getKeys = function() {
		var key;
		for (key in $scope.tabData.taskAttributes) {
			$scope.allowedKeys.push(key);
		}
	}

	$scope.getBusinessAttributes = function() {
		$scope.businessAttributes = $scope.tabData.taskAttributes;
	}
	
	$scope.isValidDate = function(){
		return angular.isDate($scope.dateObject.date);
	};
}]);
