'use strict';

angular.module('gms-develop-cs', [
  'ngCookies',
  'ngResource',
  'ngSanitize',
  'ngRoute',
  'ngSanitize',
  'ark.core',
  //'ark-components',
  'ark-ui-bootstrap',
  'angularTreeview',
  'ark-common',
  'cs.query',
  'cs.tree',
  'cs.create-service',
  'cs.create-task',
  'cs.create-state',
  'cs.complete',
  'wu.masonry',
  'angularMoment',
  'ark-searchable-input',
  'cs.timeline',
  'cs.timelineLink',
  'cs.services',
  'cs.filter',
  'journey-manager',
  'cs.services.util',
  'ngAnimate',
  'cs.history',
  'cs.dashboard.timelineLink',
  'cs.dashboard.query',
  'timelineFilter',
  'gms.localization',
  'ark.calendar',
  'gridster',
  //'gms.monitor',
  //'gms.configured-services',
  'gms.preferences',
  'ark-d3',
  'ark-dashboard',
  //'common-dashboard-module',
  //'ui.sortable',
  'ark.graphs',
  'custom-bar-graph',
  // tools
  //'gms.serviceTemplates',
 // 'gms.resources',
  //'gms.sample',
 // 'gms.patterns',
 // 'gms.downloadDfm',
    'gms.logger',
 // 'gms.metrics',
 // 'gms.logService',
])

.config(function($routeProvider, $httpProvider, $provide, $sceDelegateProvider, $compileProvider, $locationProvider) {

  var originalWhen = $routeProvider.when;
  
    $routeProvider
		.when('/', {
            templateUrl: 'app/modules/context-services/developer/context.html',
        })
        .when('/journey', {
            templateUrl: 'app/modules/context-services/journey-dashboard/context.html',
        })
        .otherwise(
        {
          redirectTo: '/' // the default page
        });


    $httpProvider.defaults.headers.common['Cache-Control'] = 'no-cache';
    $httpProvider.defaults.headers.common.Pragma = 'no-cache';
    // To allow the downloading of the callback cancellation report
    $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|data|ftp|mailto|chrome-extension):/);
    $locationProvider.hashPrefix('');
})


.controller('MainCtrl',
  function($scope, $http, $location, $routeParams, $log,navigationBarService, localizationService, preferencesService, $window, $q, GLOBAL_URL, GLOBAL_PROFILE_EXTENSIONS, JTimeLineQuery) {
    
    $scope.isIE = false;
    // will be called from the nav bar to update the current page name
    // the function will change the route according to the specified page name
    $scope.changeView = function changeView(pageName) {
      $location.path(pageName);
    };

    let navDefer = $q.defer();
    let navPromise = navDefer.promise;

    localizationService.getLocaleJSON(function(locale){
      $scope.footerText = locale.Common.GMS + " " + localStorage.getItem("version");
      $window.document.title = locale.Common.APP_NAME_GMS;
      //navigationBarService.initialize().then(() => navDefer.resolve())
      navigationBarService.initialize();
    });
}).factory('JTimeLineQuery', function($resource, $log, GLOBAL_URL, GLOBAL_PROFILE_EXTENSIONS){
  var primaryKey = '';
  var customerProperties = GLOBAL_PROFILE_EXTENSIONS.CustomerProperties;
  for(var i = 0; i < customerProperties.length; i++){
    if(customerProperties[i].primaryKey && customerProperties[i].primaryKey ==='yes'){
      primaryKey = customerProperties[i].label;
      break;
    }
  }

  if(primaryKey === ''){
    $log.error("ERROR: No Primary Key provided");
  } else {
    var url = GLOBAL_URL.CSProfileApiUrl + "/:" + primaryKey;
    return $resource (url, null, null);
  }
});
