////////////////////////////
/// Variables
////////////////////////////


// Session 
var objSessionData = { secureKey: "" },


    // Chat
    intLastTranscriptPosition = 0,
    boolDisconnected = true,
    boolRestoring = false,

    // CometD
    objCometD = false,
    objCometDSettings = { cometURL: "",
        channel: "", websocketEnabled: true, logLevel: "info"
    },
    boolCometDConnected = false,
    intHandshakeExceptionCount = 0,
    intHandshakeExceptionLimit = 5;


//// Connect GMS
function chatV2Start(url, channel) {

    chatUi.runToast("Connecting", 'info');
    // Instantiating CometD
    // For each chat session, open a CometD connection
    objCometD = new org.cometd.CometD();
    // Optionally, install an extension.
    objCometD.registerExtension('timestamp', new org.cometd.TimeStampExtension());

    // Enable WebSockets
    objCometD.websocketEnabled = objCometDSettings.websocketEnabled;

    // Provide your GMS CometD Endpoint
    objCometDSettings.cometURL = url;
    objCometD.configure({
        url: url,
        logLevel: "info"
    });

    /// Add listeners for cometD meta endpoints
    objCometD.addListener('/meta/handshake', fHandshake);
    objCometD.addListener('/meta/connect', fConnect);
    objCometD.addListener('/meta/disconnect', fDisconnect);
    objCometD.addListener('/meta/publish', fPublish);
    // Listen to chat notifications
    objCometDSettings.channel = channel;
    objCometD.addListener(objCometDSettings.channel, refresh);

    // Now, handshake
    objCometD.handshake();

};
////////////////////////////
/// CometD Meta Handlers
////////////////////////////

// Handle handshake
function fHandshake(response) {

    console.log('fHandshake', response);

    if (response.successful === false) {
        if (++intHandshakeExceptionCount === intHandshakeExceptionLimit) {
            /// Too many exceptions, close CometD connection
            disconnectFromGMS();
            intHandshakeExceptionCount = 0;
            // Update UI
            chatUi.stopWaiting();
            chatUi.runToast("Handshake failed", 'alert');
        }
    } else if (response.successful === true) {
        chatUi.runToast("Handshake success", 'info');

        boolCometDConnected = true;
        chatUi.boolGMSConnected = true;
        intHandshakeExceptionCount = 0;

        if (response.secureKey && boolRestoring) {
            chatUi.runToast("Restoring notifications", 'info');
            // If the handshake is successful, submit a requestNotifications request
            // otherwise client messages are not exchanged properly.
            request("requestNotifications", {
                secureKey: response.secureKey,
                transcriptPosition: intLastTranscriptPosition,
                message: "" // get current text in text input
            });
            boolRestoring = false;
        } else {
            chatUi.stopWaiting();
            chatUi.runToast("Start chat session", 'info');
            // Start a chat session
            var requestChatData = {
                operation: "requestChat",
                nickname: chatUi.strNickname,
                subject: "Test CometD Chat v2",
                text: "",
                "userData": {
                    "interests": "javascript"
                }
            }
            objCometD.publish(objCometDSettings.channel, requestChatData);

        }
    }
}
// Handle publish events
function fPublish(response) {
    console.log('fPublish', response);
    if (boolCometDConnected) {
        if (response.successful === false) {
            chatUi.runDialog("Could not publish to channel. <br/>" + response.error);

        } else if (!chatUi.bSessionActive) {
            chatUi.boolSessionActive = true;
            chatUi.runToast("Chat session started");
        }
    }

}
// Handle connection events
function fConnect(response) {
    if (!objCometD || objCometD.isDisconnected()) {
        boolCometDConnected = false;
        chatUi.runToast("CometD is no longer connected!", "alert");
        return;
    }

    boolCometDConnected = response.successful == true;

    // If chat was disconnected but CometD has reconnected
    if (boolDisconnected && boolCometDConnected) {
        boolDisconnected = false;
        if (!chatUi.boolChatServerOnline) {
            /// Requesting chat messages$
            request("requestNotifications", {
                transcriptPosition: intLastTranscriptPosition
            });
            /// Updating the chat server status
            chatUi.boolChatServerOnline = true;
            chatUi.runToast("CometD reconnected", "info");
        }
    } else if (!boolDisconnected && !boolCometDConnected) {
        if (response.error !== "402:: Unknown client") {
            boolDisconnected = true;
            chatUi.boolGMSConnected = false;
            /// Notify disconnection status
            chatUi.runToast("CometD is disconnected! " + response.error, "alert");

        }
    }
}
/// Handle status after disconnection request
function fDisconnect(response) {
    console.log('disconnect', response);
    if (response.successful) {
        boolDisconnected = true;
        chatUi.boolChatServerOnline = false;
        chatUi.boolGMSConnected = false;
        chatUi.boolSessionActive = false;
        /// if CometD is not set to false,
        /// trying to reconnect
        if (objCometD) {
            chatUi.runToast("CometD - disconnection", "alert");
            boolRestoring = true;
            objCometD.handshake();
        } else {
            objSessionData.secureKey = "";
            chatUi.runToast("CometD - disconnection", "info");
        }

    } else {
        chatUi.runToast("CometD - disconnection " + response.error, "error");
    }
}
////////////////////////////
/// Chat 
////////////////////////////

//// Perform ChatV2 queries. CometD requests need to include the secureKey for each operation.
function request (operation, params) {
    if (objCometD && boolCometDConnected) {
        var data = {
            operation: operation,
            secureKey: objSessionData.secureKey,
        };
        var finalData = $.extend(data, params);
        objCometD.publish(objCometDSettings.channel, finalData);
    } else {
        chatUi.runToast("CometD is not connected!", "alert");
    }
}
/// Refresh upon  notifications
function refresh(response) {
    console.log('refresh', response, boolCometDConnected);
    chatUi.runToast("Received notification", "info");
    if (boolCometDConnected) {
        response = response.data;

        /// Make sure to retrieve session parameters
        // only secureKey is required
        if (response.secureKey) objSessionData.secureKey = response.secureKey;

        if (response.statusCode === 2 && response.errors && response.errors.length > 0) {
            /// Process the received errors     
            chatUi.boolSessionActive = false;
            var errorToDisplay = "Chat API error: <br/>";
            response.errors.forEach(element => { errorToDisplay += element.advice + "<br/>" });

            chatUi.runDialog(errorToDisplay, "alert");
        }


        // Prevents situation where you can't end an expired chat session
        if (response.statusCode === 0) {

            if (!chatUi.boolChatServerOnline) {
                /// Chat Server is back online
                chatUi.boolChatServerOnline = true;
                chatUi.runToast("Chat server is back online", "info");
            }

            if (response.messages.length > 0) {
                // Parse the chat transcript
                parseTranscript(response);
            }

        } else if (response.statusCode === 1) {
            chatUi.boolChatServerOnline = false;
            chatUi.runToast("Chat server is offline", "warn");
        }
    }
}

/// Parse transcript messages received within a notification
function parseTranscript(transcript) {
    // Update chat display if needed
    $.each(transcript.messages || [], function () {
        /// TIP: Use the index to check if you previously processed this message
        if (this.index > intLastTranscriptPosition) {
            switch (this.type) {
                case 'ParticipantJoined':
                    chatUi.displayMessage(this.from.nickname, '<i> Joined </i>');
                    break;
                case 'Message':
                    if (this.from.type !== 'Client') {
                        // In this sample, the chat widget already displayed 
                        // the client message
                        chatUi.displayMessage(this.from.nickname, this.text);
                    }
                    break;
                case 'ParticipantLeft': chatUi.displayMessage(this.from.nickname, '<i> Left </i>');
                    break;
                default: console.log(this);
            }
            intLastTranscriptPosition = this.index;
        }

    });
    // Check if the session has ended
    if (transcript.chatEnded === true) {
        chatUi.boolSessionActive = false;
        disconnectFromGMS();
    }
}

/// Terminate the chat session before disconnecting CometD
function terminateChatSession() {
    chatUi.runToast("Terminate Chat session...", "warn");
    intLastTranscriptPosition = -1;
    request('disconnect', {});

}

/// Disconnect from GMS
function disconnectFromGMS() {
    console.log("disconnect from GMS");

    /// Clean up
    objSessionData.secureKey = "";
    intLastTranscriptPosition = -1;

    /// Stop cometD
    if (boolCometDConnected && objCometD) {
        objCometD.disconnect();
        objCometD = false;
        boolCometDConnected = false;
    }
}
/// Send chat messages using CometD
function sendMessage(nickname, message) {
    chatUi.runToast("Send message...", "info");
    request('sendMessage', { message: message, nickname: nickname });
}

