({

    //Accept messages from channel and convert and path to library
    handleChanged: function(cmp, event, helper) {
        var data = {};
        var fields= ['protocolVersion','referenceId','request','userAgent','data','event','errorMessage']
        if (event != null && event.getParam("protocolVersion") != null) {
            for(var i=0;i<fields.length;i++){
                if(event.getParam(fields[i])){
                    data[fields[i]]=event.getParam(fields[i])
                }
            }
            window.genesys.wwe.service.messageReceiver(data);
        }
    },
    //Triggering when SCAPI library was loaded.
    scriptsLoaded: function(component, event, helper) {
        console.log('scripts loaded');
        var MCname = component.get("v.channel");
        var channelLink = component.find('GplusChannel');

        if (!window.genesys) { window.genesys = {}; }
        if (!window.genesys.adapter) { window.genesys.adapter = {}; }
        if (!window.genesys.adapter.sample) {
            var Sample = function (channel) {
                var subscriptionToMC;
                var iteration=0;
                var subscribed=false;

                this.log=function(text,color) {
                    var divOutput = document.getElementById("output");
                    divOutput.innerHTML = "<pre style=\"color:"+color+"\">" + text + "</pre><br/>" + divOutput.innerHTML;
                }

                this.succeeded=function(result) {
                    var color='green';
                    var text = "SUCCEEDED, result: " + JSON.stringify(result, null, "\t")
                    var divOutput = document.getElementById("output");
                    divOutput.innerHTML = "<pre style=\"color:"+color+"\">" + text + "</pre><br/>" + divOutput.innerHTML;
                };

                this.failed=function(result) {
                    var color='red';
                    var text = "FAILED, result: " + JSON.stringify(result, null, "\t");
                    var divOutput = document.getElementById("output");
                    divOutput.innerHTML = "<pre style=\"color:"+color+"\">" + text + "</pre><br/>" + divOutput.innerHTML;
                };

                this.eventHandler=function(message) {
                    console.log('Event message');
                    switch (message.event) {
                        case "agent":
                            this.log("Received agent event: " + JSON.stringify(message, null, "\t"));
                            break;
                        case "interaction":
                            this.log("Received interaction event: " + JSON.stringify(message, null, "\t"));
                            break;
                        case "markdone":
                            this.log("Received markdone event: " + JSON.stringify(message, null, "\t"));
                            break;
                        case "media":
                            this.log("Received media event: " + JSON.stringify(message, null, "\t"));
                            break;
                        case "system":
                            this.log("Received system event: " + JSON.stringify(message, null, "\t"));
                            break;

                        default:
                    }
                };
                // Called when the current web page is loaded.
                this.initializeWebPage=function(MCannel,channel) {
                    console.log('Init web page automatically');
                    //Init API
                    this.initializeAPI(MCannel,channel);

                    window.genesys.wwe.service.onMessage = function(eventName) {
                        log("Received event: " + eventName,'red');
                        switch (eventName) {
                            case "wweInitialized":
                                // The #Workspace iframe is initialized
                                // Subscribe to Workspace Web Edition
                                if(!subscribed){
                                    this.subscribe();
                                }

                                break;
                            case "wweExit":
                                break;
                            case "wweDisconnected":
                                break;
                            case "wweReconnected":
                                break;
                        }
                    }.bind(this);

                };

                this.initializeAPI=function(MCname,channel) {
                    genesys.wwe.service.init(MCname,channel);
                    this.checkIsWWEexist();
                };

                this.checkIsWWEexist=function(){
                    var that=this
                    var succesCallbac =this.subscribe.bind(this);
                    genesys.wwe.service.agent.get(succesCallbac, function () {
                        console.log('SCAPI sample wwe don\'t exist')
                        //onece again
                        iteration=iteration+1;
                        if(iteration<10){
                            that.checkIsWWEexist();
                        }
                    });
                }
                this.subscribe=function () {
                    var that=this;
                    if(!subscribed){
                        genesys.wwe.service.subscribe(["agent", "interaction", "media", "system", "markdone"], that.eventHandler, that);
                        subscribed=true;
                    }
                }
            }
            window.genesys.adapter.sample=new Sample();

        }
        window.genesys.adapter.sample.initializeWebPage.call(window.genesys.adapter.sample,MCname,channelLink);
    },

    showCommand:function(component,event,helper) {
        var commandName = event.currentTarget.dataset.command;
        var command = "", commandHelp = "";
        switch (commandName) {
            case "agent.get":
                command = 'genesys.wwe.service.agent.get(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the agent attributes.";
                break;
            case "agent.getStateList":
                command = 'genesys.wwe.service.agent.getStateList(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the list of possible states of the agent.";
                break;
            case "agent.setState":
                command = 'genesys.wwe.service.agent.setState("NotReady", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Set the agent state.";
                break;
            case "agent.getState":
                command = 'genesys.wwe.service.agent.getState(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the agent state.";
                break;
            case "interaction.getInteractions":
                command = 'genesys.wwe.service.interaction.getInteractions(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get all the interactions.";
                break;
            case "interaction.getByInteractionId":
                command = 'genesys.wwe.service.interaction.getByInteractionId("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get an interaction by its interaction identifier.";
                break;
            case "interaction.setUserData":
                command = 'genesys.wwe.service.interaction.setUserData("1", { KEY1: "MyValue111", KEY2: "MyValue222" }, window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Set the user data to the live interaction.";
                break;
            case "interaction.deleteUserData":
                command = 'genesys.wwe.service.interaction.deleteUserData("1", "KEY1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Deletes the user data attached to the interaction.";
                break;
            case "interaction.selectCaseByCaseId":
                command = 'genesys.wwe.service.interaction.selectCaseByCaseId("********-****-****-****-************", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Select the case in the UI by case identifier.";
                break;
            case "interaction.markdone":
                command = 'genesys.wwe.service.interaction.markdone("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Mark done the selected interaction.";
                break;
            case "interaction.blockMarkdone":
                command = 'genesys.wwe.service.interaction.blockMarkdone("1", "My warning message!", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Block the mark done operation on the selected interaction.";
                break;
            case "interaction.unblockMarkdone":
                command = 'genesys.wwe.service.interaction.unblockMarkdone("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Unblock the mark done operation on the selected interaction.";
                break;
            case "interaction.accept":
                command = 'genesys.wwe.service.interaction.accept("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Accept the interaction.";
                break;
            case "interaction.reject":
                command = 'genesys.wwe.service.interaction.reject("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Reject the interaction.";
                break;
            case "voice.dial":
                command = 'genesys.wwe.service.voice.dial("*PhoneNumber*", { myAttachedDataKey1: "myAttachedDataValue1", myAttachedDataKey2: "myAttachedDataValue2" }, window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Call the destination with the optional attached data.";
                break;
            case "voice.answer":
                command = 'genesys.wwe.service.voice.answer("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Answer the call.";
                break;
            case "voice.hold":
                command = 'genesys.wwe.service.voice.hold("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Hold the call.";
                break;
            case "voice.resume":
                command = 'genesys.wwe.service.voice.resume("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Resume the call.";
                break;
            case "voice.hangUp":
                command = 'genesys.wwe.service.voice.hangUp("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Release the call.";
                break;
            case "voice.startCallRecording":
                command = 'genesys.wwe.service.voice.startCallRecording("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Start the call recording.";
                break;
            case "voice.stopCallRecording":
                command = 'genesys.wwe.service.voice.stopCallRecording("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Stop the call recording.";
                break;
            case "voice.pauseCallRecording":
                command = 'genesys.wwe.service.voice.pauseCallRecording("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Pause the call recording.";
                break;
            case "voice.resumeCallRecording":
                command = 'genesys.wwe.service.voice.resumeCallRecording("1", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Resume the call recording.";
                break;
            case "sipEndpoint.muteMicrophone":
                command = 'genesys.wwe.service.sipEndpoint.muteMicrophone(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Mute the microphone of the SIP Endpoint.";
                break;
            case "sipEndpoint.unmuteMicrophone":
                command = 'genesys.wwe.service.sipEndpoint.unmuteMicrophone(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Unmute the microphone of the SIP Endpoint.";
                break;
            case "sipEndpoint.muteSpeaker":
                command = 'genesys.wwe.service.sipEndpoint.muteSpeaker(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Mute the speaker of the SIP Endpoint.";
                break;
            case "sipEndpoint.unmuteSpeaker":
                command = 'genesys.wwe.service.sipEndpoint.unmuteSpeaker(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Unmute the speaker of the SIP Endpoint.";
                break;
            case "sipEndpoint.isMicrophoneMute":
                command = 'genesys.wwe.service.sipEndpoint.isMicrophoneMute(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the mute state of the microphone of the SIP Endpoint.";
                break;
            case "sipEndpoint.isSpeakerMute":
                command = 'genesys.wwe.service.sipEndpoint.isSpeakerMute(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the mute state of the speaker of the SIP Endpoint.";
                break;
            case "email.create":
                command = 'genesys.wwe.service.email.create("omaha@gmail.com", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Create a new empty email.";
                break;
            case "media.getMediaList":
                command = 'genesys.wwe.service.media.getMediaList(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get the media attributes.";
                break;
            case "media.getMediaByName":
                command = 'genesys.wwe.service.media.getMediaByName("voice", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Get a media by its name.";
                break;
            case "media.setState":
                command = 'genesys.wwe.service.media.setState("voice", "NotReady", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Set the media state.";
                break;
            case "system.triggerActivity":
                command = 'genesys.wwe.service.system.triggerActivity(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Trigger an activity.";
                break;
            case "system.getAllowedServices":
                command = 'genesys.wwe.service.system.getAllowedServices(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Following the security configuration, this service retrieves the list of allowed services.";
                break;
            case "system.popupToast":
                command = 'genesys.wwe.service.system.popupToast({\n\
    title: "The title",\n\
    iconUrl: "https://cdn3.iconfinder.com/data/icons/rssicons/PNG/001.png",\n\
    subject: "The great subject",\n\
    message: "The long enough message,\\r\\nwith several lines\\nbut not that much.",\n\
    keyValues: {\n\
        "key1": "value one",\n\
        "key2": "value two",\n\
        "key3": "value three"\n\
    },\n\
    //buttons: [ "Show", "Dismiss" ]\n\
    buttonShowDismiss: true,\n\
    autoCloseTimeout: 20000,\n\
    sendToMyMessage: true\n\
}, window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Popup a customizable toast.";
                break;
            case "system.updateToast":
                command = 'genesys.wwe.service.system.updateToast("wweCustomToast0", {\n\
    title: "The title",\n\
    iconUrl: "https://cdn3.iconfinder.com/data/icons/rssicons/PNG/001.png",\n\
    subject: "The great subject",\n\
    message: "The long enough message,\\r\\nwith several lines\\nbut not that much.",\n\
    keyValues: {\n\
        "key1": "1111111111111111",\n\
        "key3": "3333333333333"\n\
    },\n\
    buttons: [ "AAAAA", "BBBBB", "CCCCC" ]\n\
    //buttonShowDismiss: true\n\
}, window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Popup a customizable toast.";
                break;
            case "system.closeToast":
                command = 'genesys.wwe.service.system.closeToast("wweCustomToast0", window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = "Close a customizable toast.";
                break;
            case "auth.getJwtToken":
                command = 'genesys.wwe.service.auth.getJwtToken(window.genesys.adapter.sample.succeeded, window.genesys.adapter.sample.failed)';
                commandHelp = 'Get the JWT OAuth access token for current session.';
                break;
        }
        document.getElementById("command").value = command;
        commandHelp += " The 'succeeded' and 'failed' arguments are the callback functions called asynchronously to send the result.";
        document.getElementById("commandHelp").innerText = commandHelp;
    },
    executeCommand:function() {
        eval(document.getElementById("command").value);
    },
    clearCommand:function() {
        document.getElementById('output').innerHTML = '';
    }

})
